/*
 * Written by Dawid Kurzyniec and released to the public domain, as explained
 * at http://creativecommons.org/licenses/publicdomain
 */

package edu.emory.mathcs.util.net.inproc;

import java.io.*;
import java.net.*;

/**
 * Represents an address of in-proc socket. Consists of a logical port
 * number.
 *
 * @author Dawid Kurzyniec
 * @version 1.0
 */
public class InProcSocketAddress extends SocketAddress {

    final int port;

    /**
     * Creates new inproc socket address representing specified logical port.
     * @param port the logical port
     */
    public InProcSocketAddress(int port) {
        if (port < 0) throw new IllegalArgumentException("Port number must be non-negative");
        this.port = port;
    }

    /**
     * Returns the logical port number represented by this inproc socket
     * address.
     *
     * @return logical port number
     */
    public int getPort() {
        return port;
    }

    public int hashCode() {
        return port;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof InProcSocketAddress)) return false;
        InProcSocketAddress that = (InProcSocketAddress)obj;
        return this.port == that.port;
    }

    public String toString() {
        return String.valueOf(port);
    }
}
